/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.prometheus.exporter;

import java.util.Collections;
import java.util.List;
import net.thisptr.jackson.jq.exception.JsonQueryException;
import org.apache.solr.core.Config;
import org.apache.solr.prometheus.exporter.MetricsQuery;
import org.apache.solr.prometheus.exporter.PrometheusExporterSettings;
import org.w3c.dom.Node;

public class MetricsConfiguration {
    private final PrometheusExporterSettings settings;
    private final List<MetricsQuery> pingConfiguration;
    private final List<MetricsQuery> metricsConfiguration;
    private final List<MetricsQuery> collectionsConfiguration;
    private final List<MetricsQuery> searchConfiguration;

    private MetricsConfiguration(PrometheusExporterSettings settings, List<MetricsQuery> pingConfiguration, List<MetricsQuery> metricsConfiguration, List<MetricsQuery> collectionsConfiguration, List<MetricsQuery> searchConfiguration) {
        this.settings = settings;
        this.pingConfiguration = pingConfiguration;
        this.metricsConfiguration = metricsConfiguration;
        this.collectionsConfiguration = collectionsConfiguration;
        this.searchConfiguration = searchConfiguration;
    }

    public PrometheusExporterSettings getSettings() {
        return this.settings;
    }

    public List<MetricsQuery> getPingConfiguration() {
        return this.pingConfiguration;
    }

    public List<MetricsQuery> getMetricsConfiguration() {
        return this.metricsConfiguration;
    }

    public List<MetricsQuery> getCollectionsConfiguration() {
        return this.collectionsConfiguration;
    }

    public List<MetricsQuery> getSearchConfiguration() {
        return this.searchConfiguration;
    }

    public static MetricsConfiguration from(Config config) throws Exception {
        Node settings = config.getNode("/config/settings", false);
        Node pingConfig = config.getNode("/config/rules/ping", false);
        Node metricsConfig = config.getNode("/config/rules/metrics", false);
        Node collectionsConfig = config.getNode("/config/rules/collections", false);
        Node searchConfiguration = config.getNode("/config/rules/search", false);
        return new MetricsConfiguration(settings == null ? PrometheusExporterSettings.builder().build() : PrometheusExporterSettings.from(settings), MetricsConfiguration.toMetricQueries(pingConfig), MetricsConfiguration.toMetricQueries(metricsConfig), MetricsConfiguration.toMetricQueries(collectionsConfig), MetricsConfiguration.toMetricQueries(searchConfiguration));
    }

    private static List<MetricsQuery> toMetricQueries(Node node) throws JsonQueryException {
        if (node == null) {
            return Collections.emptyList();
        }
        return MetricsQuery.from(node);
    }
}

