/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.core;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoNamespace;
import com.mongodb.ServerAddress;
import com.mongodb.client.MongoCollection;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.bson.conversions.Bson;
import org.rrd4j.core.RrdBackend;
import org.rrd4j.core.RrdBackendFactory;
import org.rrd4j.core.RrdMongoDBBackend;

public class RrdMongoDBBackendFactory
extends RrdBackendFactory {
    private final URI rootUri;
    private final MongoWrapper wrapper;

    @Deprecated
    public RrdMongoDBBackendFactory(DBCollection rrdCollection) {
        this(rrdCollection, true);
    }

    @Deprecated
    public RrdMongoDBBackendFactory(final DBCollection rrdCollection, boolean registerAsDefault) {
        if (registerAsDefault) {
            RrdBackendFactory.registerAndSetAsDefaultFactory(this);
        }
        this.wrapper = new MongoWrapper(){

            @Override
            public void makeIndex(BasicDBObject index) {
                rrdCollection.createIndex((DBObject)index);
            }

            @Override
            public boolean exists(BasicDBObject query) {
                return rrdCollection.find((DBObject)query).hasNext();
            }

            @Override
            public DBObject get(BasicDBObject query) {
                return rrdCollection.findOne((DBObject)query);
            }

            @Override
            public void save(BasicDBObject query, byte[] rrd) {
                DBObject rrdObject = rrdCollection.findOne((DBObject)query);
                if (rrdObject == null) {
                    rrdObject = new BasicDBObject();
                    rrdObject.put("path", query.get("path"));
                    rrdObject.put("rrd", (Object)rrd);
                }
                rrdCollection.save(rrdObject);
            }

            @Override
            public List<ServerAddress> servers() {
                return rrdCollection.getDB().getMongo().getServerAddressList();
            }
        };
        DB db = rrdCollection.getDB();
        this.rootUri = this.buildRootUri(db.getName(), rrdCollection.getName(), db.getMongo().getServerAddressList());
        this.makeIndex();
    }

    public RrdMongoDBBackendFactory(final MongoClient client, final MongoCollection<DBObject> rrdCollection, boolean registerAsDefault) {
        this.wrapper = new MongoWrapper(){

            @Override
            public void makeIndex(BasicDBObject index) {
                rrdCollection.createIndex((Bson)index);
            }

            @Override
            public boolean exists(BasicDBObject query) {
                return rrdCollection.count((Bson)query) != 0L;
            }

            @Override
            public DBObject get(BasicDBObject query) {
                return (DBObject)rrdCollection.find((Bson)query).first();
            }

            @Override
            public void save(BasicDBObject query, byte[] rrd) {
                String path = (String)query.get("path");
                DBObject rrdObject = (DBObject)rrdCollection.find((Bson)query).first();
                if (rrdObject == null) {
                    rrdObject = new BasicDBObject();
                    rrdObject.put("path", (Object)path);
                    rrdObject.put("rrd", (Object)rrd);
                    rrdCollection.insertOne((Object)rrdObject);
                } else {
                    rrdObject.put("rrd", (Object)rrd);
                    rrdCollection.replaceOne((Bson)query, (Object)rrdObject);
                }
            }

            @Override
            public List<ServerAddress> servers() {
                return client.getServerAddressList();
            }
        };
        MongoNamespace ns = rrdCollection.getNamespace();
        this.rootUri = this.buildRootUri(ns.getDatabaseName(), ns.getCollectionName(), client.getServerAddressList());
        this.makeIndex();
    }

    private URI buildRootUri(String dbName, String collectionName, List<ServerAddress> servers) {
        StringBuilder buffer = new StringBuilder();
        for (ServerAddress sa : servers) {
            buffer.append(sa.getHost() + ":" + sa.getPort() + ",");
        }
        buffer.deleteCharAt(buffer.length() - 1);
        try {
            return new URI("mongodb", buffer.toString(), "/" + dbName + "/" + collectionName + "/", null, null);
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex.getMessage(), ex);
        }
    }

    private void makeIndex() {
        this.wrapper.makeIndex(new BasicDBObject("path", (Object)1));
    }

    @Override
    public URI getRootUri() {
        return this.rootUri;
    }

    @Override
    protected RrdBackend open(String path, boolean readOnly) throws IOException {
        return new RrdMongoDBBackend(path, this.wrapper);
    }

    @Override
    protected boolean exists(String path) throws IOException {
        BasicDBObject query = new BasicDBObject();
        query.put((Object)"path", (Object)path);
        return this.wrapper.exists(query);
    }

    @Override
    protected boolean shouldValidateHeader(String path) throws IOException {
        return false;
    }

    @Override
    protected boolean shouldValidateHeader(URI uri) throws IOException {
        return false;
    }

    @Override
    public String getName() {
        return "MONGODB";
    }

    @Override
    public String getScheme() {
        return "mongodb";
    }

    @Override
    protected URI resolve(URI rootUri, URI uri, boolean relative) {
        try {
            URI tryUri = new URI(uri.getScheme(), null, uri.getPath(), uri.getQuery(), uri.getFragment());
            URI resolvedUri = super.resolve(rootUri, tryUri, relative);
            if (resolvedUri == null) {
                return null;
            }
            String rawHost = uri.getRawAuthority();
            if (rawHost == null || rawHost.length() == 0) {
                return resolvedUri;
            }
            HashSet<ServerAddress> tryHosts = new HashSet<ServerAddress>();
            int n = 0;
            String[] stringArray = rawHost.split(",");
            int n2 = stringArray.length;
            if (n < n2) {
                String hostInfo = stringArray[n];
                String[] parts = hostInfo.split(":");
                if (parts.length == 1) {
                    tryHosts.add(new ServerAddress(parts[0]));
                } else if (parts.length == 2) {
                    try {
                        tryHosts.add(new ServerAddress(parts[0], Integer.parseInt(parts[1])));
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("can 't parse mongodb URI " + uri.toString());
                    }
                } else {
                    throw new IllegalArgumentException("can 't parse mongodb URI " + uri.toString());
                }
                if (!Collections.disjoint(tryHosts, this.wrapper.servers())) {
                    return resolvedUri;
                }
                return null;
            }
        }
        catch (URISyntaxException e) {
            return null;
        }
        return null;
    }

    @Override
    public boolean canStore(URI uri) {
        if ((uri = this.resolve(this.rootUri, uri, false)) == null) {
            return false;
        }
        String rawHost = uri.getRawAuthority();
        if (rawHost == null || rawHost.length() == 0) {
            return true;
        }
        HashSet<ServerAddress> tryHosts = new HashSet<ServerAddress>();
        for (String hostInfo : rawHost.split(",")) {
            String[] parts = hostInfo.split(":");
            if (parts.length == 1) {
                tryHosts.add(new ServerAddress(parts[0]));
                continue;
            }
            if (parts.length == 2) {
                try {
                    tryHosts.add(new ServerAddress(parts[0], Integer.parseInt(parts[1])));
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("can 't parse mongodb URI " + uri.toString());
                }
            }
            throw new IllegalArgumentException("can 't parse mongodb URI " + uri.toString());
        }
        return !Collections.disjoint(tryHosts, this.wrapper.servers());
    }

    static interface MongoWrapper {
        public void makeIndex(BasicDBObject var1);

        public boolean exists(BasicDBObject var1);

        public DBObject get(BasicDBObject var1);

        public void save(BasicDBObject var1, byte[] var2);

        public List<ServerAddress> servers();
    }
}

