/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.util;

import com.carrotsearch.hppc.predicates.ShortPredicate;
import java.util.Iterator;

public final class IntArrayPredicateIterator
implements Iterator<Integer> {
    private ShortPredicate separator;
    private short[] array;
    private int rangeStart;
    private int rangeLength;
    private final int length;
    private final int toIndex;

    public IntArrayPredicateIterator(short[] array, int from, int length, ShortPredicate separator) {
        this.separator = separator;
        this.array = array;
        this.length = length;
        this.toIndex = from + length;
        this.rangeStart = from - 1;
    }

    public IntArrayPredicateIterator(short[] array, ShortPredicate separator) {
        this(array, 0, array.length, separator);
    }

    @Override
    public boolean hasNext() {
        return this.length > 0 && this.rangeStart < this.toIndex;
    }

    @Override
    public Integer next() {
        int result = this.rangeStart;
        this.rangeStart = this.nextSeparator(this.rangeStart);
        this.rangeLength = this.rangeStart - result - 1;
        return result + 1;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public int getLength() {
        return this.rangeLength;
    }

    private int nextSeparator(int position) {
        while (++position < this.toIndex && !this.separator.apply(this.array[position])) {
        }
        return position;
    }
}

