/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler;

import java.io.Closeable;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.request.AbstractUpdateRequest;
import org.apache.solr.client.solrj.request.QueryRequest;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkCoreNodeProps;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.common.util.IOUtils;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.CloseHook;
import org.apache.solr.core.PluginBag;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrInfoBean;
import org.apache.solr.handler.CdcrBufferManager;
import org.apache.solr.handler.CdcrBufferStateManager;
import org.apache.solr.handler.CdcrLeaderStateManager;
import org.apache.solr.handler.CdcrParams;
import org.apache.solr.handler.CdcrProcessStateManager;
import org.apache.solr.handler.CdcrReplicatorManager;
import org.apache.solr.handler.CdcrReplicatorState;
import org.apache.solr.handler.CdcrUpdateLogSynchronizer;
import org.apache.solr.handler.ReplicationHandler;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.handler.admin.CoreAdminHandler;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrRequestHandler;
import org.apache.solr.request.SolrRequestInfo;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.update.CdcrUpdateLog;
import org.apache.solr.update.SolrCoreState;
import org.apache.solr.update.UpdateLog;
import org.apache.solr.update.VersionInfo;
import org.apache.solr.util.DefaultSolrThreadFactory;
import org.apache.solr.util.plugin.SolrCoreAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CdcrRequestHandler
extends RequestHandlerBase
implements SolrCoreAware {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private SolrCore core;
    private String collection;
    private String shard;
    private String path;
    private SolrParams updateLogSynchronizerConfiguration;
    private SolrParams replicatorConfiguration;
    private SolrParams bufferConfiguration;
    private Map<String, List<SolrParams>> replicasConfiguration;
    private CdcrProcessStateManager processStateManager;
    private CdcrBufferStateManager bufferStateManager;
    private CdcrReplicatorManager replicatorManager;
    private CdcrLeaderStateManager leaderStateManager;
    private CdcrUpdateLogSynchronizer updateLogSynchronizer;
    private CdcrBufferManager bufferManager;

    @Override
    public void init(NamedList args) {
        super.init(args);
        if (args != null) {
            Object bufferParam;
            Object replicatorParam;
            Object updateLogSynchonizerParam = args.get("updateLogSynchronizer");
            if (updateLogSynchonizerParam != null && updateLogSynchonizerParam instanceof NamedList) {
                this.updateLogSynchronizerConfiguration = ((NamedList)updateLogSynchonizerParam).toSolrParams();
            }
            if ((replicatorParam = args.get("replicator")) != null && replicatorParam instanceof NamedList) {
                this.replicatorConfiguration = ((NamedList)replicatorParam).toSolrParams();
            }
            if ((bufferParam = args.get("buffer")) != null && bufferParam instanceof NamedList) {
                this.bufferConfiguration = ((NamedList)bufferParam).toSolrParams();
            }
            this.replicasConfiguration = new HashMap<String, List<SolrParams>>();
            List replicas = args.getAll("replica");
            for (Object replica : replicas) {
                if (replica == null || !(replica instanceof NamedList)) continue;
                SolrParams params = ((NamedList)replica).toSolrParams();
                if (!this.replicasConfiguration.containsKey(params.get("source"))) {
                    this.replicasConfiguration.put(params.get("source"), new ArrayList());
                }
                this.replicasConfiguration.get(params.get("source")).add(params);
            }
        }
    }

    @Override
    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        SolrParams params = req.getParams();
        CdcrParams.CdcrAction action = null;
        String a = params.get("action");
        if (a != null) {
            action = CdcrParams.CdcrAction.get(a);
        }
        if (action == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown action: " + a);
        }
        switch (action) {
            case START: {
                this.handleStartAction(req, rsp);
                break;
            }
            case STOP: {
                this.handleStopAction(req, rsp);
                break;
            }
            case STATUS: {
                this.handleStatusAction(req, rsp);
                break;
            }
            case COLLECTIONCHECKPOINT: {
                this.handleCollectionCheckpointAction(req, rsp);
                break;
            }
            case SHARDCHECKPOINT: {
                this.handleShardCheckpointAction(req, rsp);
                break;
            }
            case ENABLEBUFFER: {
                this.handleEnableBufferAction(req, rsp);
                break;
            }
            case DISABLEBUFFER: {
                this.handleDisableBufferAction(req, rsp);
                break;
            }
            case LASTPROCESSEDVERSION: {
                this.handleLastProcessedVersionAction(req, rsp);
                break;
            }
            case QUEUES: {
                this.handleQueuesAction(req, rsp);
                break;
            }
            case OPS: {
                this.handleOpsAction(req, rsp);
                break;
            }
            case ERRORS: {
                this.handleErrorsAction(req, rsp);
                break;
            }
            case BOOTSTRAP: {
                this.handleBootstrapAction(req, rsp);
                break;
            }
            case BOOTSTRAP_STATUS: {
                this.handleBootstrapStatus(req, rsp);
                break;
            }
            case CANCEL_BOOTSTRAP: {
                this.handleCancelBootstrap(req, rsp);
                break;
            }
            default: {
                throw new RuntimeException("Unknown action: " + (Object)((Object)action));
            }
        }
        rsp.setHttpCaching(false);
    }

    @Override
    public void inform(SolrCore core) {
        this.core = core;
        this.collection = core.getCoreDescriptor().getCloudDescriptor().getCollectionName();
        this.shard = core.getCoreDescriptor().getCloudDescriptor().getShardId();
        if (!core.getCoreContainer().isZooKeeperAware()) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Solr instance is not running in SolrCloud mode.");
        }
        if (!(core.getUpdateHandler().getUpdateLog() instanceof CdcrUpdateLog)) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Solr instance is not configured with the cdcr update log.");
        }
        this.path = null;
        for (Map.Entry<String, PluginBag.PluginHolder<SolrRequestHandler>> entry : core.getRequestHandlers().getRegistry().entrySet()) {
            if (!core.getRequestHandlers().isLoaded(entry.getKey()) || entry.getValue().get() != this) continue;
            this.path = entry.getKey();
            break;
        }
        if (this.path == null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "The CdcrRequestHandler is not registered with the current core.");
        }
        if (!this.path.startsWith("/")) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "The CdcrRequestHandler needs to be registered to a path. Typically this is '/cdcr'");
        }
        this.bufferStateManager = new CdcrBufferStateManager(core, this.bufferConfiguration);
        this.processStateManager = new CdcrProcessStateManager(core);
        this.leaderStateManager = new CdcrLeaderStateManager(core);
        this.replicatorManager = new CdcrReplicatorManager(core, this.path, this.replicatorConfiguration, this.replicasConfiguration);
        this.replicatorManager.setProcessStateManager(this.processStateManager);
        this.replicatorManager.setLeaderStateManager(this.leaderStateManager);
        this.replicatorManager.stateUpdate();
        this.updateLogSynchronizer = new CdcrUpdateLogSynchronizer(core, this.path, this.updateLogSynchronizerConfiguration);
        this.updateLogSynchronizer.setLeaderStateManager(this.leaderStateManager);
        this.updateLogSynchronizer.stateUpdate();
        this.bufferManager = new CdcrBufferManager(core);
        this.bufferManager.setLeaderStateManager(this.leaderStateManager);
        this.bufferManager.setBufferStateManager(this.bufferStateManager);
        this.bufferManager.stateUpdate();
        this.registerCloseHook(core);
    }

    private void registerCloseHook(SolrCore core) {
        core.addCloseHook(new CloseHook(){

            @Override
            public void preClose(SolrCore core) {
                log.info("Solr core is being closed - shutting down CDCR handler @ {}:{}", (Object)CdcrRequestHandler.this.collection, (Object)CdcrRequestHandler.this.shard);
                CdcrRequestHandler.this.updateLogSynchronizer.shutdown();
                CdcrRequestHandler.this.replicatorManager.shutdown();
                CdcrRequestHandler.this.bufferStateManager.shutdown();
                CdcrRequestHandler.this.processStateManager.shutdown();
                CdcrRequestHandler.this.leaderStateManager.shutdown();
            }

            @Override
            public void postClose(SolrCore core) {
            }
        });
    }

    private void handleStartAction(SolrQueryRequest req, SolrQueryResponse rsp) {
        if (this.processStateManager.getState() == CdcrParams.ProcessState.STOPPED) {
            this.processStateManager.setState(CdcrParams.ProcessState.STARTED);
            this.processStateManager.synchronize();
        }
        rsp.add(CdcrParams.CdcrAction.STATUS.toLower(), this.getStatus());
    }

    private void handleStopAction(SolrQueryRequest req, SolrQueryResponse rsp) {
        if (this.processStateManager.getState() == CdcrParams.ProcessState.STARTED) {
            this.processStateManager.setState(CdcrParams.ProcessState.STOPPED);
            this.processStateManager.synchronize();
        }
        rsp.add(CdcrParams.CdcrAction.STATUS.toLower(), this.getStatus());
    }

    private void handleStatusAction(SolrQueryRequest req, SolrQueryResponse rsp) {
        rsp.add(CdcrParams.CdcrAction.STATUS.toLower(), this.getStatus());
    }

    private NamedList getStatus() {
        NamedList status = new NamedList();
        status.add(CdcrParams.ProcessState.getParam(), (Object)this.processStateManager.getState().toLower());
        status.add(CdcrParams.BufferState.getParam(), (Object)this.bufferStateManager.getState().toLower());
        return status;
    }

    private void handleCollectionCheckpointAction(SolrQueryRequest req, SolrQueryResponse rsp) throws IOException, SolrServerException {
        ZkController zkController = this.core.getCoreContainer().getZkController();
        try {
            zkController.getZkStateReader().forceUpdateCollection(this.collection);
        }
        catch (Exception e) {
            log.warn("Error when updating cluster state", (Throwable)e);
        }
        ClusterState cstate = zkController.getClusterState();
        DocCollection docCollection = cstate.getCollectionOrNull(this.collection);
        Collection shards = docCollection == null ? null : docCollection.getActiveSlices();
        ExecutorService parallelExecutor = ExecutorUtil.newMDCAwareCachedThreadPool((ThreadFactory)new DefaultSolrThreadFactory("parallelCdcrExecutor"));
        long checkpoint = Long.MAX_VALUE;
        try {
            ArrayList<SliceCheckpointCallable> callables = new ArrayList<SliceCheckpointCallable>();
            for (Slice slice : shards) {
                Replica leaderProps = zkController.getZkStateReader().getLeaderRetry(this.collection, slice.getName());
                ZkCoreNodeProps nodeProps = new ZkCoreNodeProps((ZkNodeProps)leaderProps);
                callables.add(new SliceCheckpointCallable(nodeProps.getCoreUrl(), this.path));
            }
            for (Future future : parallelExecutor.invokeAll(callables)) {
                long version = (Long)future.get();
                if (version >= checkpoint) continue;
                checkpoint = version;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error while requesting shard's checkpoints", (Throwable)e);
        }
        catch (ExecutionException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error while requesting shard's checkpoints", (Throwable)e);
        }
        finally {
            parallelExecutor.shutdown();
        }
        rsp.add("checkpoint", checkpoint);
    }

    private void handleShardCheckpointAction(SolrQueryRequest req, SolrQueryResponse rsp) {
        if (!this.leaderStateManager.amILeader()) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Action '" + (Object)((Object)CdcrParams.CdcrAction.SHARDCHECKPOINT) + "' sent to non-leader replica");
        }
        UpdateLog ulog = this.core.getUpdateHandler().getUpdateLog();
        VersionInfo versionInfo = ulog.getVersionInfo();
        try (UpdateLog.RecentUpdates recentUpdates = ulog.getRecentUpdates();){
            long maxVersionFromRecent = recentUpdates.getMaxRecentVersion();
            long maxVersionFromIndex = versionInfo.getMaxVersionFromIndex(req.getSearcher());
            log.info("Found maxVersionFromRecent {} maxVersionFromIndex {}", (Object)maxVersionFromRecent, (Object)maxVersionFromIndex);
            long maxVersion = Math.max(maxVersionFromIndex, maxVersionFromRecent);
            if (maxVersion == 0L) {
                maxVersion = -1L;
            }
            rsp.add("checkpoint", maxVersion);
        }
        catch (IOException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Action '" + (Object)((Object)CdcrParams.CdcrAction.SHARDCHECKPOINT) + "' could not read max version");
        }
    }

    private void handleEnableBufferAction(SolrQueryRequest req, SolrQueryResponse rsp) {
        if (this.bufferStateManager.getState() == CdcrParams.BufferState.DISABLED) {
            this.bufferStateManager.setState(CdcrParams.BufferState.ENABLED);
            this.bufferStateManager.synchronize();
        }
        rsp.add(CdcrParams.CdcrAction.STATUS.toLower(), this.getStatus());
    }

    private void handleDisableBufferAction(SolrQueryRequest req, SolrQueryResponse rsp) {
        if (this.bufferStateManager.getState() == CdcrParams.BufferState.ENABLED) {
            this.bufferStateManager.setState(CdcrParams.BufferState.DISABLED);
            this.bufferStateManager.synchronize();
        }
        rsp.add(CdcrParams.CdcrAction.STATUS.toLower(), this.getStatus());
    }

    private void handleLastProcessedVersionAction(SolrQueryRequest req, SolrQueryResponse rsp) {
        String collectionName = this.core.getCoreDescriptor().getCloudDescriptor().getCollectionName();
        String shard = this.core.getCoreDescriptor().getCloudDescriptor().getShardId();
        if (!this.leaderStateManager.amILeader()) {
            log.warn("Action {} sent to non-leader replica @ {}:{}", new Object[]{CdcrParams.CdcrAction.LASTPROCESSEDVERSION, collectionName, shard});
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Action " + (Object)((Object)CdcrParams.CdcrAction.LASTPROCESSEDVERSION) + " sent to non-leader replica");
        }
        long lastProcessedVersion = Long.MAX_VALUE;
        for (CdcrReplicatorState state : this.replicatorManager.getReplicatorStates()) {
            long version = Long.MAX_VALUE;
            if (state.getLogReader() != null) {
                version = state.getLogReader().getLastVersion();
            }
            lastProcessedVersion = Math.min(lastProcessedVersion, version);
        }
        CdcrUpdateLog.CdcrLogReader bufferLogReader = ((CdcrUpdateLog)this.core.getUpdateHandler().getUpdateLog()).getBufferToggle();
        if (bufferLogReader != null) {
            lastProcessedVersion = Math.min(lastProcessedVersion, bufferLogReader.getLastVersion());
        }
        if (this.processStateManager.getState().equals((Object)CdcrParams.ProcessState.STOPPED) && this.bufferStateManager.getState().equals((Object)CdcrParams.BufferState.DISABLED)) {
            try (CdcrUpdateLog.CdcrLogReader logReader = ((CdcrUpdateLog)this.core.getUpdateHandler().getUpdateLog()).newLogReader();){
                logReader.next();
                lastProcessedVersion = Math.min(lastProcessedVersion, logReader.getLastVersion());
            }
        }
        log.debug("Returning the lowest last processed version {}  @ {}:{}", new Object[]{lastProcessedVersion, collectionName, shard});
        rsp.add("lastProcessedVersion", lastProcessedVersion);
    }

    private void handleQueuesAction(SolrQueryRequest req, SolrQueryResponse rsp) {
        NamedList hosts = new NamedList();
        for (CdcrReplicatorState state : this.replicatorManager.getReplicatorStates()) {
            NamedList queueStats = new NamedList();
            CdcrUpdateLog.CdcrLogReader logReader = state.getLogReader();
            if (logReader == null) {
                String collectionName = req.getCore().getCoreDescriptor().getCloudDescriptor().getCollectionName();
                String shard = req.getCore().getCoreDescriptor().getCloudDescriptor().getShardId();
                log.warn("The log reader for target collection {} is not initialised @ {}:{}", new Object[]{state.getTargetCollection(), collectionName, shard});
                queueStats.add("queueSize", (Object)-1L);
            } else {
                queueStats.add("queueSize", (Object)logReader.getNumberOfRemainingRecords());
            }
            queueStats.add("lastTimestamp", (Object)state.getTimestampOfLastProcessedOperation());
            if (hosts.get(state.getZkHost()) == null) {
                hosts.add(state.getZkHost(), (Object)new NamedList());
            }
            ((NamedList)hosts.get(state.getZkHost())).add(state.getTargetCollection(), (Object)queueStats);
        }
        rsp.add("queues", hosts);
        UpdateLog updateLog = this.core.getUpdateHandler().getUpdateLog();
        rsp.add("tlogTotalSize", updateLog.getTotalLogsSize());
        rsp.add("tlogTotalCount", updateLog.getTotalLogsNumber());
        rsp.add("updateLogSynchronizer", this.updateLogSynchronizer.isStarted() ? CdcrParams.ProcessState.STARTED.toLower() : CdcrParams.ProcessState.STOPPED.toLower());
    }

    private void handleOpsAction(SolrQueryRequest req, SolrQueryResponse rsp) {
        NamedList hosts = new NamedList();
        for (CdcrReplicatorState state : this.replicatorManager.getReplicatorStates()) {
            NamedList ops = new NamedList();
            ops.add("all", (Object)state.getBenchmarkTimer().getOperationsPerSecond());
            ops.add("adds", (Object)state.getBenchmarkTimer().getAddsPerSecond());
            ops.add("deletes", (Object)state.getBenchmarkTimer().getDeletesPerSecond());
            if (hosts.get(state.getZkHost()) == null) {
                hosts.add(state.getZkHost(), (Object)new NamedList());
            }
            ((NamedList)hosts.get(state.getZkHost())).add(state.getTargetCollection(), (Object)ops);
        }
        rsp.add("operationsPerSecond", hosts);
    }

    private void handleErrorsAction(SolrQueryRequest req, SolrQueryResponse rsp) {
        NamedList hosts = new NamedList();
        for (CdcrReplicatorState state : this.replicatorManager.getReplicatorStates()) {
            NamedList errors = new NamedList();
            errors.add("consecutiveErrors", (Object)state.getConsecutiveErrors());
            errors.add(CdcrReplicatorState.ErrorType.BAD_REQUEST.toLower(), (Object)state.getErrorCount(CdcrReplicatorState.ErrorType.BAD_REQUEST));
            errors.add(CdcrReplicatorState.ErrorType.INTERNAL.toLower(), (Object)state.getErrorCount(CdcrReplicatorState.ErrorType.INTERNAL));
            NamedList lastErrors = new NamedList();
            for (String[] lastError : state.getLastErrors()) {
                lastErrors.add(lastError[0], (Object)lastError[1]);
            }
            errors.add("last", (Object)lastErrors);
            if (hosts.get(state.getZkHost()) == null) {
                hosts.add(state.getZkHost(), (Object)new NamedList());
            }
            ((NamedList)hosts.get(state.getZkHost())).add(state.getTargetCollection(), (Object)errors);
        }
        rsp.add("errors", hosts);
    }

    private void handleBootstrapAction(SolrQueryRequest req, SolrQueryResponse rsp) throws IOException, InterruptedException, SolrServerException {
        String collectionName = this.core.getCoreDescriptor().getCloudDescriptor().getCollectionName();
        String shard = this.core.getCoreDescriptor().getCloudDescriptor().getShardId();
        if (!this.leaderStateManager.amILeader()) {
            log.warn("Action {} sent to non-leader replica @ {}:{}", new Object[]{CdcrParams.CdcrAction.BOOTSTRAP, collectionName, shard});
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Action " + (Object)((Object)CdcrParams.CdcrAction.BOOTSTRAP) + " sent to non-leader replica");
        }
        CountDownLatch latch = new CountDownLatch(1);
        Runnable runnable = () -> {
            Lock recoveryLock = req.getCore().getSolrCoreState().getRecoveryLock();
            boolean locked = recoveryLock.tryLock();
            SolrCoreState coreState = this.core.getSolrCoreState();
            try {
                if (!locked) {
                    this.handleCancelBootstrap(req, rsp);
                } else if (this.leaderStateManager.amILeader()) {
                    coreState.setCdcrBootstrapRunning(true);
                    latch.countDown();
                    String masterUrl = req.getParams().get("masterUrl");
                    BootstrapCallable bootstrapCallable = new BootstrapCallable(masterUrl, this.core);
                    coreState.setCdcrBootstrapCallable(bootstrapCallable);
                    Future<Boolean> bootstrapFuture = this.core.getCoreContainer().getUpdateShardHandler().getRecoveryExecutor().submit(bootstrapCallable);
                    coreState.setCdcrBootstrapFuture(bootstrapFuture);
                    try {
                        bootstrapFuture.get();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        log.warn("Bootstrap was interrupted", (Throwable)e);
                    }
                    catch (ExecutionException e) {
                        log.error("Bootstrap operation failed", (Throwable)e);
                    }
                } else {
                    log.error("Action {} sent to non-leader replica @ {}:{}. Aborting bootstrap.", new Object[]{CdcrParams.CdcrAction.BOOTSTRAP, collectionName, shard});
                }
            }
            finally {
                if (locked) {
                    coreState.setCdcrBootstrapRunning(false);
                    recoveryLock.unlock();
                } else {
                    latch.countDown();
                }
            }
        };
        try {
            this.core.getCoreContainer().getUpdateShardHandler().getUpdateExecutor().submit(runnable);
            rsp.add(CoreAdminHandler.RESPONSE_STATUS, "submitted");
            latch.await(10000L, TimeUnit.MILLISECONDS);
        }
        catch (RejectedExecutionException ree) {
            rsp.add(CoreAdminHandler.RESPONSE_STATUS, "failed");
        }
    }

    private void handleCancelBootstrap(SolrQueryRequest req, SolrQueryResponse rsp) {
        BootstrapCallable callable = (BootstrapCallable)this.core.getSolrCoreState().getCdcrBootstrapCallable();
        IOUtils.closeQuietly((Closeable)callable);
        rsp.add(CoreAdminHandler.RESPONSE_STATUS, "cancelled");
    }

    private void handleBootstrapStatus(SolrQueryRequest req, SolrQueryResponse rsp) throws IOException, SolrServerException {
        block12: {
            SolrCoreState coreState = this.core.getSolrCoreState();
            if (coreState.getCdcrBootstrapRunning()) {
                rsp.add(CoreAdminHandler.RESPONSE_STATUS, CoreAdminHandler.RUNNING);
                return;
            }
            Future<Boolean> future = coreState.getCdcrBootstrapFuture();
            BootstrapCallable callable = (BootstrapCallable)coreState.getCdcrBootstrapCallable();
            if (future == null) {
                rsp.add(CoreAdminHandler.RESPONSE_STATUS, "notfound");
                rsp.add(CoreAdminHandler.RESPONSE_MESSAGE, "No bootstrap found in running, completed or failed states");
            } else if (future.isCancelled() || callable.isClosed()) {
                rsp.add(CoreAdminHandler.RESPONSE_STATUS, "cancelled");
            } else if (future.isDone()) {
                try {
                    Boolean result = future.get();
                    if (result.booleanValue()) {
                        rsp.add(CoreAdminHandler.RESPONSE_STATUS, CoreAdminHandler.COMPLETED);
                        break block12;
                    }
                    rsp.add(CoreAdminHandler.RESPONSE_STATUS, CoreAdminHandler.FAILED);
                }
                catch (InterruptedException result) {
                }
                catch (ExecutionException e) {
                    rsp.add(CoreAdminHandler.RESPONSE_STATUS, CoreAdminHandler.FAILED);
                    rsp.add(CoreAdminHandler.RESPONSE, e);
                }
                catch (CancellationException ce) {
                    rsp.add(CoreAdminHandler.RESPONSE_STATUS, CoreAdminHandler.FAILED);
                    rsp.add(CoreAdminHandler.RESPONSE_MESSAGE, "Bootstrap was cancelled");
                }
            } else {
                rsp.add(CoreAdminHandler.RESPONSE_STATUS, CoreAdminHandler.RUNNING);
            }
        }
    }

    @Override
    public String getDescription() {
        return "Manage Cross Data Center Replication";
    }

    @Override
    public SolrInfoBean.Category getCategory() {
        return SolrInfoBean.Category.REPLICATION;
    }

    private static final class SliceCheckpointCallable
    implements Callable<Long> {
        final String baseUrl;
        final String cdcrPath;

        SliceCheckpointCallable(String baseUrl, String cdcrPath) {
            this.baseUrl = baseUrl;
            this.cdcrPath = cdcrPath;
        }

        @Override
        public Long call() throws Exception {
            try (HttpSolrClient server = ((HttpSolrClient.Builder)((HttpSolrClient.Builder)new HttpSolrClient.Builder(this.baseUrl).withConnectionTimeout(15000)).withSocketTimeout(60000)).build();){
                ModifiableSolrParams params = new ModifiableSolrParams();
                params.set("action", new String[]{CdcrParams.CdcrAction.SHARDCHECKPOINT.toString()});
                QueryRequest request = new QueryRequest((SolrParams)params);
                request.setPath(this.cdcrPath);
                NamedList response = server.request((SolrRequest)request);
                Long l = (Long)response.get("checkpoint");
                return l;
            }
        }
    }

    static class BootstrapCallable
    implements Callable<Boolean>,
    Closeable {
        private final String masterUrl;
        private final SolrCore core;
        private volatile boolean closed = false;

        BootstrapCallable(String masterUrl, SolrCore core) {
            this.masterUrl = masterUrl;
            this.core = core;
        }

        @Override
        public void close() throws IOException {
            this.closed = true;
            SolrRequestHandler handler = this.core.getRequestHandler("/replication");
            ReplicationHandler replicationHandler = (ReplicationHandler)handler;
            replicationHandler.abortFetch();
        }

        public boolean isClosed() {
            return this.closed;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean call() throws Exception {
            boolean success = false;
            UpdateLog ulog = this.core.getUpdateHandler().getUpdateLog();
            ulog.bufferUpdates();
            try {
                this.commitOnLeader(this.masterUrl);
                SolrRequestHandler handler = this.core.getRequestHandler("/replication");
                ReplicationHandler replicationHandler = (ReplicationHandler)handler;
                if (replicationHandler == null) {
                    throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "Skipping recovery, no /replication handler found");
                }
                ModifiableSolrParams solrParams = new ModifiableSolrParams();
                solrParams.set("masterUrl", new String[]{this.masterUrl});
                solrParams.set("tlogFiles", false);
                success = replicationHandler.doFetch((SolrParams)solrParams, false).getSuccessful();
                SolrRequestInfo.clearRequestInfo();
                Future<UpdateLog.RecoveryInfo> future = ulog.applyBufferedUpdates();
                if (future == null) {
                    log.info("No replay needed.");
                } else {
                    log.info("Replaying buffered documents.");
                    UpdateLog.RecoveryInfo report = future.get();
                    if (report.failed) {
                        SolrException.log((Logger)log, (String)"Replay failed");
                        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Replay failed");
                    }
                }
                Boolean bl = success;
                return bl;
            }
            finally {
                if (this.closed || !success) {
                    boolean dropped = ulog.dropBufferedUpdates();
                    assert (dropped);
                }
            }
        }

        private void commitOnLeader(String leaderUrl) throws SolrServerException, IOException {
            try (HttpSolrClient client = ((HttpSolrClient.Builder)new HttpSolrClient.Builder(leaderUrl).withConnectionTimeout(30000)).build();){
                UpdateRequest ureq = new UpdateRequest();
                ureq.setParams(new ModifiableSolrParams());
                ureq.getParams().set("commit_end_point", true);
                ureq.getParams().set("openSearcher", false);
                ureq.setAction(AbstractUpdateRequest.ACTION.COMMIT, false, true).process((SolrClient)client);
            }
        }
    }
}

