/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.logging;

import java.util.function.Supplier;
import org.apache.solr.cloud.CloudDescriptor;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.CoreDescriptor;
import org.apache.solr.core.SolrCore;
import org.slf4j.MDC;

public class MDCLoggingContext {
    private static ThreadLocal<Integer> CALL_DEPTH = ThreadLocal.withInitial(new Supplier<Integer>(){

        @Override
        public Integer get() {
            return 0;
        }
    });

    public static void setCollection(String collection) {
        if (collection != null) {
            MDC.put((String)"collection", (String)("c:" + collection));
        } else {
            MDC.remove((String)"collection");
        }
    }

    public static void setShard(String shard) {
        if (shard != null) {
            MDC.put((String)"shard", (String)("s:" + shard));
        } else {
            MDC.remove((String)"shard");
        }
    }

    public static void setReplica(String replica) {
        if (replica != null) {
            MDC.put((String)"replica", (String)("r:" + replica));
        } else {
            MDC.remove((String)"replica");
        }
    }

    public static void setCoreName(String core) {
        if (core != null) {
            MDC.put((String)"core", (String)("x:" + core));
        } else {
            MDC.remove((String)"core");
        }
    }

    public static void setNode(CoreContainer cc) {
        ZkController zk;
        if (cc != null && (zk = cc.getZkController()) != null) {
            MDCLoggingContext.setNode(zk.getNodeName());
        }
    }

    public static void setNode(String node) {
        int used = CALL_DEPTH.get();
        if (used == 0) {
            MDCLoggingContext.setNodeName(node);
        }
    }

    private static void setNodeName(String node) {
        if (node != null) {
            MDC.put((String)"node_name", (String)("n:" + node));
        } else {
            MDC.remove((String)"node_name");
        }
    }

    public static void setCore(SolrCore core) {
        if (core != null) {
            MDCLoggingContext.setCoreDescriptor(core.getCoreContainer(), core.getCoreDescriptor());
        }
    }

    public static void setCoreDescriptor(CoreContainer coreContainer, CoreDescriptor cd) {
        if (cd != null) {
            CloudDescriptor ccd;
            ZkController zkController;
            int callDepth = CALL_DEPTH.get();
            CALL_DEPTH.set(callDepth + 1);
            if (callDepth > 0) {
                return;
            }
            MDCLoggingContext.setCoreName(cd.getName());
            if (coreContainer != null && (zkController = coreContainer.getZkController()) != null) {
                MDCLoggingContext.setNodeName(zkController.getNodeName());
            }
            if ((ccd = cd.getCloudDescriptor()) != null) {
                MDCLoggingContext.setCollection(ccd.getCollectionName());
                MDCLoggingContext.setShard(ccd.getShardId());
                MDCLoggingContext.setReplica(ccd.getCoreNodeName());
            }
        }
    }

    public static void clear() {
        int used = CALL_DEPTH.get();
        CALL_DEPTH.set(used - 1);
        if (used == 0) {
            MDC.remove((String)"collection");
            MDC.remove((String)"core");
            MDC.remove((String)"replica");
            MDC.remove((String)"shard");
        }
    }

    private static void removeAll() {
        MDC.remove((String)"collection");
        MDC.remove((String)"core");
        MDC.remove((String)"replica");
        MDC.remove((String)"shard");
        MDC.remove((String)"node_name");
    }

    public static void reset() {
        CALL_DEPTH.set(0);
        MDCLoggingContext.removeAll();
    }
}

