/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.Sort;

public class ProjectSortTransposeRule
extends RelOptRule {
    public static final ProjectSortTransposeRule INSTANCE = new ProjectSortTransposeRule();

    private ProjectSortTransposeRule() {
        super(ProjectSortTransposeRule.operand(Project.class, ProjectSortTransposeRule.operand(Sort.class, ProjectSortTransposeRule.any()), new RelOptRuleOperand[0]));
    }

    protected ProjectSortTransposeRule(RelOptRuleOperand operand) {
        super(operand);
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Project project = (Project)call.rel(0);
        Sort sort = (Sort)call.rel(1);
        if (sort.getClass() != Sort.class) {
            return;
        }
        RelNode newProject = project.copy(project.getTraitSet(), (List<RelNode>)ImmutableList.of((Object)sort.getInput()));
        Sort newSort = sort.copy(sort.getTraitSet(), newProject, sort.getCollation(), sort.offset, sort.fetch);
        call.transformTo(newSort);
    }
}

