/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.fun;

import com.google.common.base.Preconditions;
import org.apache.calcite.avatica.util.TimeUnitRange;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCharStringLiteral;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.fun.SqlMonotonicUnaryFunction;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.validate.SqlMonotonicity;

public class SqlFloorFunction
extends SqlMonotonicUnaryFunction {
    public SqlFloorFunction(SqlKind kind) {
        super(kind.name(), kind, ReturnTypes.ARG0_OR_EXACT_NO_SCALE, null, OperandTypes.or(OperandTypes.NUMERIC_OR_INTERVAL, OperandTypes.sequence("'" + (Object)((Object)kind) + "(<DATE> TO <TIME_UNIT>)'\n'" + (Object)((Object)kind) + "(<TIME> TO <TIME_UNIT>)'\n'" + (Object)((Object)kind) + "(<TIMESTAMP> TO <TIME_UNIT>)'", OperandTypes.DATETIME, OperandTypes.ANY)), SqlFunctionCategory.NUMERIC);
        Preconditions.checkArgument((kind == SqlKind.FLOOR || kind == SqlKind.CEIL ? 1 : 0) != 0);
    }

    @Override
    public SqlMonotonicity getMonotonicity(SqlOperatorBinding call) {
        return call.getOperandMonotonicity(0).unstrict();
    }

    @Override
    public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        if (call.operandCount() == 2) {
            this.unparseDatetime(writer, call);
        } else {
            this.unparseNumeric(writer, call);
        }
    }

    private void unparseNumeric(SqlWriter writer, SqlCall call) {
        SqlWriter.Frame frame = writer.startFunCall(this.getName());
        ((SqlNode)call.operand(0)).unparse(writer, 0, 0);
        writer.endFunCall(frame);
    }

    private void unparseDatetime(SqlWriter writer, SqlCall call) {
        if (this.kind != SqlKind.FLOOR) {
            this.unparseDatetimeDefault(writer, call);
            return;
        }
        switch (writer.getDialect().getDatabaseProduct()) {
            case UNKNOWN: 
            case CALCITE: {
                this.unparseDatetimeDefault(writer, call);
                return;
            }
        }
        SqlLiteral timeUnitNode = (SqlLiteral)call.operand(1);
        TimeUnitRange timeUnit = timeUnitNode.getValueAs(TimeUnitRange.class);
        switch (writer.getDialect().getDatabaseProduct()) {
            case ORACLE: {
                this.replaceTimeUnitOperand(call, timeUnit.name(), timeUnitNode.getParserPosition());
                this.unparseDatetimeFunction(writer, call, "TRUNC", true);
                break;
            }
            case HSQLDB: {
                String translatedLit = SqlFloorFunction.convertToHsqlDb(timeUnit);
                this.replaceTimeUnitOperand(call, translatedLit, timeUnitNode.getParserPosition());
                this.unparseDatetimeFunction(writer, call, "TRUNC", true);
                break;
            }
            case POSTGRESQL: {
                this.replaceTimeUnitOperand(call, timeUnit.name(), timeUnitNode.getParserPosition());
                this.unparseDatetimeFunction(writer, call, "DATE_TRUNC", false);
                break;
            }
            case MSSQL: {
                this.unparseDatetimeMssql(writer, call);
                break;
            }
            case MYSQL: {
                this.unparseDatetimeMysql(writer, call);
                break;
            }
            default: {
                this.unparseDatetimeDefault(writer, call);
            }
        }
    }

    private void replaceTimeUnitOperand(SqlCall call, String literal, SqlParserPos pos) {
        SqlCharStringLiteral literalNode = SqlLiteral.createCharString(literal, null, pos);
        call.setOperand(1, literalNode);
    }

    private void unparseDatetimeDefault(SqlWriter writer, SqlCall call) {
        SqlWriter.Frame frame = writer.startFunCall(this.getName());
        ((SqlNode)call.operand(0)).unparse(writer, 0, 100);
        writer.sep("TO");
        ((SqlNode)call.operand(1)).unparse(writer, 100, 0);
        writer.endFunCall(frame);
    }

    private void unparseDatetimeFunction(SqlWriter writer, SqlCall call, String funName, Boolean datetimeFirst) {
        SqlWriter.Frame frame = writer.startFunCall(funName);
        int firstOpIndex = datetimeFirst != false ? 0 : 1;
        int secondOpIndex = datetimeFirst != false ? 1 : 0;
        ((SqlNode)call.operand(firstOpIndex)).unparse(writer, 0, 0);
        writer.sep(",", true);
        ((SqlNode)call.operand(secondOpIndex)).unparse(writer, 0, 0);
        writer.endFunCall(frame);
    }

    private void unparseDatetimeMssql(SqlWriter writer, SqlCall call) {
        SqlLiteral node = (SqlLiteral)call.operand(1);
        TimeUnitRange unit = (TimeUnitRange)node.getValue();
        switch (unit) {
            case YEAR: {
                this.unparseMssql(writer, call, 4, "-01-01");
                break;
            }
            case MONTH: {
                this.unparseMssql(writer, call, 7, "-01");
                break;
            }
            case WEEK: {
                writer.print("CONVERT(DATETIME, CONVERT(VARCHAR(10), DATEADD(day, - (6 + DATEPART(weekday, ");
                ((SqlNode)call.operand(0)).unparse(writer, 0, 0);
                writer.print(")) % 7, ");
                ((SqlNode)call.operand(0)).unparse(writer, 0, 0);
                writer.print("), 126))");
                break;
            }
            case DAY: {
                this.unparseMssql(writer, call, 10, "");
                break;
            }
            case HOUR: {
                this.unparseMssql(writer, call, 13, ":00:00");
                break;
            }
            case MINUTE: {
                this.unparseMssql(writer, call, 16, ":00");
                break;
            }
            case SECOND: {
                this.unparseMssql(writer, call, 19, ":00");
                break;
            }
            default: {
                throw new AssertionError((Object)("MSSQL does not support FLOOR for time unit: " + unit));
            }
        }
    }

    private void unparseMssql(SqlWriter writer, SqlCall call, Integer charLen, String offset) {
        writer.print("CONVERT");
        SqlWriter.Frame frame = writer.startList("(", ")");
        writer.print("DATETIME, CONVERT(VARCHAR(" + charLen.toString() + "), ");
        ((SqlNode)call.operand(0)).unparse(writer, 0, 0);
        writer.print(", 126)");
        if (offset.length() > 0) {
            writer.print("+'" + offset + "'");
        }
        writer.endList(frame);
    }

    private static String convertToHsqlDb(TimeUnitRange unit) {
        switch (unit) {
            case YEAR: {
                return "YYYY";
            }
            case MONTH: {
                return "MM";
            }
            case DAY: {
                return "DD";
            }
            case WEEK: {
                return "WW";
            }
            case HOUR: {
                return "HH24";
            }
            case MINUTE: {
                return "MI";
            }
            case SECOND: {
                return "SS";
            }
        }
        throw new AssertionError((Object)("could not convert time unit to an HsqlDb equivalent: " + unit));
    }

    private void unparseDatetimeMysql(SqlWriter writer, SqlCall call) {
        String format;
        SqlLiteral node = (SqlLiteral)call.operand(1);
        TimeUnitRange unit = (TimeUnitRange)node.getValue();
        if (unit == TimeUnitRange.WEEK) {
            writer.print("STR_TO_DATE");
            SqlWriter.Frame frame = writer.startList("(", ")");
            writer.print("DATE_FORMAT(");
            ((SqlNode)call.operand(0)).unparse(writer, 0, 0);
            writer.print(", '%x%v-1'), '%x%v-%w'");
            writer.endList(frame);
            return;
        }
        switch (unit) {
            case YEAR: {
                format = "%Y-01-01";
                break;
            }
            case MONTH: {
                format = "%Y-%m-01";
                break;
            }
            case DAY: {
                format = "%Y-%m-%d";
                break;
            }
            case HOUR: {
                format = "%Y-%m-%d %k:00:00";
                break;
            }
            case MINUTE: {
                format = "%Y-%m-%d %k:%i:00";
                break;
            }
            case SECOND: {
                format = "%Y-%m-%d %k:%i:%s";
                break;
            }
            default: {
                throw new AssertionError((Object)("MYSQL does not support FLOOR for time unit: " + unit));
            }
        }
        writer.print("DATE_FORMAT");
        SqlWriter.Frame frame = writer.startList("(", ")");
        ((SqlNode)call.operand(0)).unparse(writer, 0, 0);
        writer.sep(",", true);
        writer.print("'" + format + "'");
        writer.endList(frame);
    }
}

