/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.type;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.calcite.sql.type.SqlTypeName;

public class SqlTypeAssignmentRules {
    private static SqlTypeAssignmentRules instance = null;
    private final Map<SqlTypeName, Set<SqlTypeName>> rules = new HashMap<SqlTypeName, Set<SqlTypeName>>();
    private final Map<SqlTypeName, Set<SqlTypeName>> coerceRules;

    private SqlTypeAssignmentRules() {
        for (SqlTypeName interval : SqlTypeName.YEAR_INTERVAL_TYPES) {
            this.rules.put(interval, SqlTypeName.YEAR_INTERVAL_TYPES);
        }
        for (SqlTypeName interval : SqlTypeName.DAY_INTERVAL_TYPES) {
            this.rules.put(interval, SqlTypeName.DAY_INTERVAL_TYPES);
        }
        this.rules.put(SqlTypeName.MULTISET, EnumSet.of(SqlTypeName.MULTISET));
        this.rules.put(SqlTypeName.TINYINT, EnumSet.of(SqlTypeName.TINYINT));
        Set<Object> rule = new HashSet<SqlTypeName>();
        rule.add((Object)SqlTypeName.TINYINT);
        rule.add((Object)SqlTypeName.SMALLINT);
        this.rules.put(SqlTypeName.SMALLINT, rule);
        rule = new HashSet();
        rule.add((Object)SqlTypeName.TINYINT);
        rule.add((Object)SqlTypeName.SMALLINT);
        rule.add((Object)SqlTypeName.INTEGER);
        this.rules.put(SqlTypeName.INTEGER, rule);
        rule = new HashSet();
        rule.add((Object)SqlTypeName.TINYINT);
        rule.add((Object)SqlTypeName.SMALLINT);
        rule.add((Object)SqlTypeName.INTEGER);
        rule.add((Object)SqlTypeName.BIGINT);
        this.rules.put(SqlTypeName.BIGINT, rule);
        rule = new HashSet();
        rule.add((Object)SqlTypeName.TINYINT);
        rule.add((Object)SqlTypeName.SMALLINT);
        rule.add((Object)SqlTypeName.INTEGER);
        rule.add((Object)SqlTypeName.BIGINT);
        rule.add((Object)SqlTypeName.DECIMAL);
        rule.add((Object)SqlTypeName.FLOAT);
        this.rules.put(SqlTypeName.FLOAT, rule);
        rule = new HashSet();
        rule.add((Object)SqlTypeName.TINYINT);
        rule.add((Object)SqlTypeName.SMALLINT);
        rule.add((Object)SqlTypeName.INTEGER);
        rule.add((Object)SqlTypeName.BIGINT);
        rule.add((Object)SqlTypeName.DECIMAL);
        rule.add((Object)SqlTypeName.FLOAT);
        rule.add((Object)SqlTypeName.REAL);
        this.rules.put(SqlTypeName.REAL, rule);
        rule = new HashSet();
        rule.add((Object)SqlTypeName.TINYINT);
        rule.add((Object)SqlTypeName.SMALLINT);
        rule.add((Object)SqlTypeName.INTEGER);
        rule.add((Object)SqlTypeName.BIGINT);
        rule.add((Object)SqlTypeName.DECIMAL);
        rule.add((Object)SqlTypeName.FLOAT);
        rule.add((Object)SqlTypeName.REAL);
        rule.add((Object)SqlTypeName.DOUBLE);
        this.rules.put(SqlTypeName.DOUBLE, rule);
        rule = new HashSet();
        rule.add((Object)SqlTypeName.TINYINT);
        rule.add((Object)SqlTypeName.SMALLINT);
        rule.add((Object)SqlTypeName.INTEGER);
        rule.add((Object)SqlTypeName.BIGINT);
        rule.add((Object)SqlTypeName.REAL);
        rule.add((Object)SqlTypeName.DOUBLE);
        rule.add((Object)SqlTypeName.DECIMAL);
        this.rules.put(SqlTypeName.DECIMAL, rule);
        rule = new HashSet();
        rule.add((Object)SqlTypeName.VARBINARY);
        rule.add((Object)SqlTypeName.BINARY);
        this.rules.put(SqlTypeName.VARBINARY, rule);
        this.rules.put(SqlTypeName.CHAR, EnumSet.of(SqlTypeName.CHAR));
        rule = new HashSet();
        rule.add((Object)SqlTypeName.CHAR);
        rule.add((Object)SqlTypeName.VARCHAR);
        this.rules.put(SqlTypeName.VARCHAR, rule);
        this.rules.put(SqlTypeName.BOOLEAN, EnumSet.of(SqlTypeName.BOOLEAN));
        rule = new HashSet();
        rule.add((Object)SqlTypeName.BINARY);
        rule.add((Object)SqlTypeName.VARBINARY);
        this.rules.put(SqlTypeName.BINARY, rule);
        rule = new HashSet();
        rule.add((Object)SqlTypeName.DATE);
        rule.add((Object)SqlTypeName.TIMESTAMP);
        this.rules.put(SqlTypeName.DATE, rule);
        rule = new HashSet();
        rule.add((Object)SqlTypeName.TIME);
        rule.add((Object)SqlTypeName.TIMESTAMP);
        this.rules.put(SqlTypeName.TIME, rule);
        this.rules.put(SqlTypeName.TIMESTAMP, EnumSet.of(SqlTypeName.TIMESTAMP));
        this.rules.put(SqlTypeName.ARRAY, EnumSet.of(SqlTypeName.ARRAY));
        rule = new HashSet();
        rule.add((Object)SqlTypeName.TINYINT);
        rule.add((Object)SqlTypeName.SMALLINT);
        rule.add((Object)SqlTypeName.INTEGER);
        rule.add((Object)SqlTypeName.BIGINT);
        rule.add((Object)SqlTypeName.DECIMAL);
        rule.add((Object)SqlTypeName.FLOAT);
        rule.add((Object)SqlTypeName.REAL);
        rule.add((Object)SqlTypeName.TIME);
        rule.add((Object)SqlTypeName.DATE);
        rule.add((Object)SqlTypeName.TIMESTAMP);
        this.rules.put(SqlTypeName.ANY, rule);
        this.coerceRules = SqlTypeAssignmentRules.copy(this.rules);
        rule = new HashSet();
        rule.add((Object)SqlTypeName.TINYINT);
        rule.add((Object)SqlTypeName.SMALLINT);
        rule.add((Object)SqlTypeName.INTEGER);
        rule.add((Object)SqlTypeName.BIGINT);
        rule.add((Object)SqlTypeName.DECIMAL);
        rule.add((Object)SqlTypeName.FLOAT);
        rule.add((Object)SqlTypeName.REAL);
        rule.add((Object)SqlTypeName.DOUBLE);
        rule.add((Object)SqlTypeName.CHAR);
        rule.add((Object)SqlTypeName.VARCHAR);
        this.coerceRules.put(SqlTypeName.TINYINT, SqlTypeAssignmentRules.copy(rule));
        this.coerceRules.put(SqlTypeName.SMALLINT, SqlTypeAssignmentRules.copy(rule));
        this.coerceRules.put(SqlTypeName.INTEGER, SqlTypeAssignmentRules.copy(rule));
        this.coerceRules.put(SqlTypeName.BIGINT, SqlTypeAssignmentRules.copy(rule));
        this.coerceRules.put(SqlTypeName.FLOAT, SqlTypeAssignmentRules.copy(rule));
        this.coerceRules.put(SqlTypeName.REAL, SqlTypeAssignmentRules.copy(rule));
        this.coerceRules.put(SqlTypeName.DECIMAL, SqlTypeAssignmentRules.copy(rule));
        this.coerceRules.put(SqlTypeName.DOUBLE, SqlTypeAssignmentRules.copy(rule));
        this.coerceRules.put(SqlTypeName.CHAR, SqlTypeAssignmentRules.copy(rule));
        this.coerceRules.put(SqlTypeName.VARCHAR, SqlTypeAssignmentRules.copy(rule));
        for (SqlTypeName exactType : SqlTypeName.EXACT_TYPES) {
            rule = this.coerceRules.get((Object)exactType);
            rule.addAll(SqlTypeName.INTERVAL_TYPES);
        }
        for (SqlTypeName typeName : SqlTypeName.INTERVAL_TYPES) {
            rule = this.coerceRules.get((Object)typeName);
            rule.add((Object)SqlTypeName.TINYINT);
            rule.add((Object)SqlTypeName.SMALLINT);
            rule.add((Object)SqlTypeName.INTEGER);
            rule.add((Object)SqlTypeName.BIGINT);
            rule.add((Object)SqlTypeName.DECIMAL);
            rule.add((Object)SqlTypeName.VARCHAR);
        }
        rule = this.coerceRules.get((Object)SqlTypeName.VARCHAR);
        rule.add((Object)SqlTypeName.BOOLEAN);
        rule.add((Object)SqlTypeName.DATE);
        rule.add((Object)SqlTypeName.TIME);
        rule.add((Object)SqlTypeName.TIMESTAMP);
        rule.addAll(SqlTypeName.INTERVAL_TYPES);
        rule = this.coerceRules.get((Object)SqlTypeName.CHAR);
        rule.add((Object)SqlTypeName.BOOLEAN);
        rule.add((Object)SqlTypeName.DATE);
        rule.add((Object)SqlTypeName.TIME);
        rule.add((Object)SqlTypeName.TIMESTAMP);
        rule.addAll(SqlTypeName.INTERVAL_TYPES);
        rule = this.coerceRules.get((Object)SqlTypeName.BOOLEAN);
        rule.add((Object)SqlTypeName.CHAR);
        rule.add((Object)SqlTypeName.VARCHAR);
        rule = new HashSet();
        rule.add((Object)SqlTypeName.DATE);
        rule.add((Object)SqlTypeName.TIMESTAMP);
        rule.add((Object)SqlTypeName.CHAR);
        rule.add((Object)SqlTypeName.VARCHAR);
        this.coerceRules.put(SqlTypeName.DATE, rule);
        rule = new HashSet();
        rule.add((Object)SqlTypeName.TIME);
        rule.add((Object)SqlTypeName.TIMESTAMP);
        rule.add((Object)SqlTypeName.CHAR);
        rule.add((Object)SqlTypeName.VARCHAR);
        this.coerceRules.put(SqlTypeName.TIME, rule);
        rule = new HashSet();
        rule.add((Object)SqlTypeName.TIMESTAMP);
        rule.add((Object)SqlTypeName.DATE);
        rule.add((Object)SqlTypeName.TIME);
        rule.add((Object)SqlTypeName.CHAR);
        rule.add((Object)SqlTypeName.VARCHAR);
        this.coerceRules.put(SqlTypeName.TIMESTAMP, rule);
    }

    public static synchronized SqlTypeAssignmentRules instance() {
        if (instance == null) {
            instance = new SqlTypeAssignmentRules();
        }
        return instance;
    }

    public boolean canCastFrom(SqlTypeName to, SqlTypeName from, boolean coerce) {
        Map<SqlTypeName, Set<SqlTypeName>> ruleset;
        assert (to != null);
        assert (from != null);
        Map<SqlTypeName, Set<SqlTypeName>> map = ruleset = coerce ? this.coerceRules : this.rules;
        if (to == SqlTypeName.NULL) {
            return false;
        }
        if (from == SqlTypeName.NULL) {
            return true;
        }
        Set<SqlTypeName> rule = ruleset.get((Object)to);
        if (rule == null) {
            throw new AssertionError((Object)("No assign rules for " + (Object)((Object)to) + " defined"));
        }
        return rule.contains((Object)from);
    }

    private static <K, V> Map<K, V> copy(Map<K, V> map) {
        HashMap<K, HashSet<Object>> copy = new HashMap<K, HashSet<Object>>();
        for (Map.Entry<K, V> e : map.entrySet()) {
            if (e.getValue() instanceof Set) {
                copy.put(e.getKey(), SqlTypeAssignmentRules.copy((Set)e.getValue()));
                continue;
            }
            copy.put(e.getKey(), (HashSet<Object>)e.getValue());
        }
        return copy;
    }

    private static <T> HashSet<T> copy(Set<T> set) {
        return new HashSet<T>(set);
    }
}

