/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.impl;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.solr.client.solrj.impl.ClusterStateProvider;
import org.apache.solr.common.AlreadyClosedException;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.cloud.ZooKeeperException;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkClientClusterStateProvider
implements ClusterStateProvider {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    volatile ZkStateReader zkStateReader;
    private boolean closeZkStateReader = true;
    String zkHost;
    int zkConnectTimeout = 15000;
    int zkClientTimeout = 45000;
    private volatile boolean isClosed = false;

    public ZkClientClusterStateProvider(ZkStateReader zkStateReader) {
        this.zkStateReader = zkStateReader;
        this.closeZkStateReader = false;
    }

    public ZkClientClusterStateProvider(Collection<String> zkHosts, String chroot) {
        this.zkHost = ZkClientClusterStateProvider.buildZkHostString(zkHosts, chroot);
    }

    public ZkClientClusterStateProvider(String zkHost) {
        this.zkHost = zkHost;
    }

    @Override
    public ClusterState.CollectionRef getState(String collection) {
        ClusterState clusterState = this.zkStateReader.getClusterState();
        if (clusterState != null) {
            return clusterState.getCollectionRef(collection);
        }
        return null;
    }

    public ZkStateReader getZkStateReader() {
        return this.zkStateReader;
    }

    @Override
    public Set<String> getLiveNodes() {
        if (this.isClosed) {
            throw new AlreadyClosedException();
        }
        ClusterState clusterState = this.zkStateReader.getClusterState();
        if (clusterState != null) {
            return clusterState.getLiveNodes();
        }
        return Collections.emptySet();
    }

    @Override
    public List<String> resolveAlias(String alias) {
        return this.zkStateReader.getAliases().resolveAliases(alias);
    }

    public Object getClusterProperty(String propertyName) {
        Map<String, Object> props = this.zkStateReader.getClusterProperties();
        return props.get(propertyName);
    }

    @Override
    public <T> T getClusterProperty(String propertyName, T def) {
        Map<String, Object> props = this.zkStateReader.getClusterProperties();
        if (props.containsKey(propertyName)) {
            return (T)props.get(propertyName);
        }
        return def;
    }

    @Override
    public ClusterState getClusterState() throws IOException {
        return this.zkStateReader.getClusterState();
    }

    @Override
    public Map<String, Object> getClusterProperties() {
        return this.zkStateReader.getClusterProperties();
    }

    @Override
    public String getPolicyNameByCollection(String coll) {
        ClusterState.CollectionRef state = this.getState(coll);
        return state == null || state.get() == null ? null : (String)state.get().getProperties().get("policy");
    }

    public void downloadConfig(String configName, Path downloadPath) throws IOException {
        this.connect();
        this.zkStateReader.getConfigManager().downloadConfigDir(configName, downloadPath);
    }

    public void uploadConfig(Path configPath, String configName) throws IOException {
        this.connect();
        this.zkStateReader.getConfigManager().uploadConfigDir(configPath, configName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect() {
        if (this.zkStateReader == null) {
            ZkClientClusterStateProvider zkClientClusterStateProvider = this;
            synchronized (zkClientClusterStateProvider) {
                if (this.zkStateReader == null) {
                    ZkStateReader zk = null;
                    try {
                        zk = new ZkStateReader(this.zkHost, this.zkClientTimeout, this.zkConnectTimeout);
                        zk.createClusterStateWatchersAndUpdate();
                        this.zkStateReader = zk;
                        log.info("Cluster at {} ready", (Object)this.zkHost);
                    }
                    catch (InterruptedException e) {
                        zk.close();
                        Thread.currentThread().interrupt();
                        throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
                    }
                    catch (KeeperException e) {
                        zk.close();
                        throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
                    }
                    catch (Exception e) {
                        if (zk != null) {
                            zk.close();
                        }
                        throw e;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        this.isClosed = true;
        if (this.zkStateReader != null && this.closeZkStateReader) {
            ZkClientClusterStateProvider zkClientClusterStateProvider = this;
            synchronized (zkClientClusterStateProvider) {
                if (this.zkStateReader != null) {
                    this.zkStateReader.close();
                }
                this.zkStateReader = null;
            }
        }
    }

    static String buildZkHostString(Collection<String> zkHosts, String chroot) {
        if (zkHosts == null || zkHosts.isEmpty()) {
            throw new IllegalArgumentException("Cannot create CloudSearchClient without valid ZooKeeper host; none specified!");
        }
        StringBuilder zkBuilder = new StringBuilder();
        int lastIndexValue = zkHosts.size() - 1;
        int i = 0;
        for (String zkHost : zkHosts) {
            zkBuilder.append(zkHost);
            if (i < lastIndexValue) {
                zkBuilder.append(",");
            }
            ++i;
        }
        if (chroot != null) {
            if (chroot.startsWith("/")) {
                zkBuilder.append(chroot);
            } else {
                throw new IllegalArgumentException("The chroot must start with a forward slash.");
            }
        }
        String zkHostString = zkBuilder.toString();
        log.debug("Final constructed zkHost string: " + zkHostString);
        return zkHostString;
    }

    public String toString() {
        return this.zkHost;
    }
}

