/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.apache.commons.math3.distribution.RealDistribution;
import org.apache.commons.math3.stat.inference.KolmogorovSmirnovTest;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.eval.RecursiveObjectEvaluator;
import org.apache.solr.client.solrj.io.eval.TwoValueWorker;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class KolmogorovSmirnovEvaluator
extends RecursiveObjectEvaluator
implements TwoValueWorker {
    private static final long serialVersionUID = 1L;

    public KolmogorovSmirnovEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
    }

    @Override
    public Object doWork(Object first, Object second) throws IOException {
        if (null == first || first instanceof List && 0L != ((List)first).stream().filter(item -> null == item).count()) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - null found for the first value", this.toExpression(this.constructingFactory)));
        }
        if (null == second || second instanceof List && 0L != ((List)second).stream().filter(item -> null == item).count()) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - null found for the second value", this.toExpression(this.constructingFactory)));
        }
        if (!(second instanceof List) || 0L != ((List)second).stream().filter(item -> !(item instanceof Number)).count()) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - found type %s for the second value, expecting a List of numbers", this.toExpression(this.constructingFactory), first.getClass().getSimpleName()));
        }
        KolmogorovSmirnovTest ks = new KolmogorovSmirnovTest();
        double[] data = ((List)second).stream().mapToDouble(item -> ((Number)item).doubleValue()).toArray();
        if (first instanceof RealDistribution) {
            RealDistribution realDistribution = (RealDistribution)first;
            HashMap<String, Double> m = new HashMap<String, Double>();
            m.put("p-value", ks.kolmogorovSmirnovTest(realDistribution, data));
            m.put("d-statistic", ks.kolmogorovSmirnovStatistic(realDistribution, data));
            return new Tuple(m);
        }
        if (first instanceof List && 0L == ((List)first).stream().filter(item -> !(item instanceof Number)).count()) {
            double[] data2 = ((List)first).stream().mapToDouble(item -> ((Number)item).doubleValue()).toArray();
            HashMap<String, Double> m = new HashMap<String, Double>();
            m.put("d-statistic", ks.kolmogorovSmirnovTest(data, data2));
            return new Tuple(m);
        }
        throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - found type %s for the first value, expecting a RealDistribution or list of numbers", this.toExpression(this.constructingFactory), first.getClass().getSimpleName()));
    }
}

