/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import org.apache.lucene.document.DoublePoint;
import org.apache.lucene.document.FloatPoint;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.SortedNumericDocValuesField;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.NumericUtils;
import org.apache.solr.common.SolrException;
import org.apache.solr.schema.NumberType;
import org.apache.solr.schema.PrimitiveFieldType;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.FunctionRangeQuery;
import org.apache.solr.search.QParser;
import org.apache.solr.search.function.ValueSourceRangeFilter;
import org.apache.solr.util.DateMathParser;

public abstract class NumericFieldType
extends PrimitiveFieldType {
    protected NumberType type;
    private static long FLOAT_MINUS_ZERO_BITS = Float.floatToIntBits(-0.0f);
    private static long DOUBLE_MINUS_ZERO_BITS = Double.doubleToLongBits(-0.0);

    @Override
    public NumberType getNumberType() {
        return this.type;
    }

    protected Query getDocValuesRangeQuery(QParser parser, SchemaField field, String min, String max, boolean minInclusive, boolean maxInclusive) {
        assert (field.hasDocValues() && (field.getType().isPointField() || !field.multiValued()));
        switch (this.getNumberType()) {
            case INTEGER: {
                return NumericFieldType.numericDocValuesRangeQuery(field.getName(), min == null ? null : Long.valueOf(NumericFieldType.parseIntFromUser(field.getName(), min)), max == null ? null : Long.valueOf(NumericFieldType.parseIntFromUser(field.getName(), max)), minInclusive, maxInclusive, field.multiValued());
            }
            case FLOAT: {
                if (field.multiValued()) {
                    return this.getRangeQueryForMultiValuedFloatDocValues(field, min, max, minInclusive, maxInclusive);
                }
                return this.getRangeQueryForFloatDoubleDocValues(field, min, max, minInclusive, maxInclusive);
            }
            case LONG: {
                return NumericFieldType.numericDocValuesRangeQuery(field.getName(), min == null ? null : Long.valueOf(NumericFieldType.parseLongFromUser(field.getName(), min)), max == null ? null : Long.valueOf(NumericFieldType.parseLongFromUser(field.getName(), max)), minInclusive, maxInclusive, field.multiValued());
            }
            case DOUBLE: {
                if (field.multiValued()) {
                    return this.getRangeQueryForMultiValuedDoubleDocValues(field, min, max, minInclusive, maxInclusive);
                }
                return this.getRangeQueryForFloatDoubleDocValues(field, min, max, minInclusive, maxInclusive);
            }
            case DATE: {
                return NumericFieldType.numericDocValuesRangeQuery(field.getName(), min == null ? null : Long.valueOf(DateMathParser.parseMath(null, min).getTime()), max == null ? null : Long.valueOf(DateMathParser.parseMath(null, max).getTime()), minInclusive, maxInclusive, field.multiValued());
            }
        }
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown type for numeric field");
    }

    protected Query getRangeQueryForFloatDoubleDocValues(SchemaField sf, String min, String max, boolean minInclusive, boolean maxInclusive) {
        Query query;
        boolean maxNegative;
        boolean minNegative;
        long maxBits;
        long minBits;
        Number maxVal;
        Number minVal;
        String fieldName = sf.getName();
        if (this.getNumberType() == NumberType.FLOAT) {
            if (min == null) {
                minVal = Float.valueOf(Float.NEGATIVE_INFINITY);
            } else {
                minVal = Float.valueOf(NumericFieldType.parseFloatFromUser(sf.getName(), min));
                if (!minInclusive) {
                    if (minVal.floatValue() == Float.POSITIVE_INFINITY) {
                        return new MatchNoDocsQuery();
                    }
                    minVal = Float.valueOf(FloatPoint.nextUp((float)minVal.floatValue()));
                }
            }
            if (max == null) {
                maxVal = Float.valueOf(Float.POSITIVE_INFINITY);
            } else {
                maxVal = Float.valueOf(NumericFieldType.parseFloatFromUser(sf.getName(), max));
                if (!maxInclusive) {
                    if (maxVal.floatValue() == Float.NEGATIVE_INFINITY) {
                        return new MatchNoDocsQuery();
                    }
                    maxVal = Float.valueOf(FloatPoint.nextDown((float)maxVal.floatValue()));
                }
            }
            minBits = Float.floatToIntBits(minVal.floatValue());
            maxBits = Float.floatToIntBits(maxVal.floatValue());
            minNegative = minVal.floatValue() < 0.0f || minBits == FLOAT_MINUS_ZERO_BITS;
            maxNegative = maxVal.floatValue() < 0.0f || maxBits == FLOAT_MINUS_ZERO_BITS;
        } else {
            assert (this.getNumberType() == NumberType.DOUBLE);
            if (min == null) {
                minVal = Double.NEGATIVE_INFINITY;
            } else {
                minVal = NumericFieldType.parseDoubleFromUser(sf.getName(), min);
                if (!minInclusive) {
                    if (minVal.doubleValue() == Double.POSITIVE_INFINITY) {
                        return new MatchNoDocsQuery();
                    }
                    minVal = DoublePoint.nextUp((double)minVal.doubleValue());
                }
            }
            if (max == null) {
                maxVal = Double.POSITIVE_INFINITY;
            } else {
                maxVal = NumericFieldType.parseDoubleFromUser(sf.getName(), max);
                if (!maxInclusive) {
                    if (maxVal.doubleValue() == Double.NEGATIVE_INFINITY) {
                        return new MatchNoDocsQuery();
                    }
                    maxVal = DoublePoint.nextDown((double)maxVal.doubleValue());
                }
            }
            minBits = Double.doubleToLongBits(minVal.doubleValue());
            maxBits = Double.doubleToLongBits(maxVal.doubleValue());
            minNegative = minVal.doubleValue() < 0.0 || minBits == DOUBLE_MINUS_ZERO_BITS;
            boolean bl = maxNegative = maxVal.doubleValue() < 0.0 || maxBits == DOUBLE_MINUS_ZERO_BITS;
        }
        if (minNegative && !maxNegative) {
            ValueSource vs = this.getValueSource(sf, null);
            query = new FunctionRangeQuery(new ValueSourceRangeFilter(vs, minVal.toString(), maxVal.toString(), true, true));
        } else {
            query = minNegative && maxNegative ? NumericFieldType.numericDocValuesRangeQuery(fieldName, maxBits, minBits, true, true, false) : NumericFieldType.numericDocValuesRangeQuery(fieldName, minBits, maxBits, true, true, false);
        }
        return query;
    }

    protected Query getRangeQueryForMultiValuedDoubleDocValues(SchemaField sf, String min, String max, boolean minInclusive, boolean maxInclusive) {
        double maxVal;
        double minVal;
        if (min == null) {
            minVal = Double.NEGATIVE_INFINITY;
        } else {
            minVal = NumericFieldType.parseDoubleFromUser(sf.getName(), min);
            if (!minInclusive) {
                if (minVal == Double.POSITIVE_INFINITY) {
                    return new MatchNoDocsQuery();
                }
                minVal = DoublePoint.nextUp((double)minVal);
            }
        }
        if (max == null) {
            maxVal = Double.POSITIVE_INFINITY;
        } else {
            maxVal = NumericFieldType.parseDoubleFromUser(sf.getName(), max);
            if (!maxInclusive) {
                if (maxVal == Double.NEGATIVE_INFINITY) {
                    return new MatchNoDocsQuery();
                }
                maxVal = DoublePoint.nextDown((double)maxVal);
            }
        }
        Long minBits = NumericUtils.doubleToSortableLong((double)minVal);
        Long maxBits = NumericUtils.doubleToSortableLong((double)maxVal);
        return NumericFieldType.numericDocValuesRangeQuery(sf.getName(), minBits, maxBits, true, true, true);
    }

    protected Query getRangeQueryForMultiValuedFloatDocValues(SchemaField sf, String min, String max, boolean minInclusive, boolean maxInclusive) {
        float maxVal;
        float minVal;
        if (min == null) {
            minVal = Float.NEGATIVE_INFINITY;
        } else {
            minVal = NumericFieldType.parseFloatFromUser(sf.getName(), min);
            if (!minInclusive) {
                if (minVal == Float.POSITIVE_INFINITY) {
                    return new MatchNoDocsQuery();
                }
                minVal = FloatPoint.nextUp((float)minVal);
            }
        }
        if (max == null) {
            maxVal = Float.POSITIVE_INFINITY;
        } else {
            maxVal = NumericFieldType.parseFloatFromUser(sf.getName(), max);
            if (!maxInclusive) {
                if (maxVal == Float.NEGATIVE_INFINITY) {
                    return new MatchNoDocsQuery();
                }
                maxVal = FloatPoint.nextDown((float)maxVal);
            }
        }
        Long minBits = NumericUtils.floatToSortableInt((float)minVal);
        Long maxBits = NumericUtils.floatToSortableInt((float)maxVal);
        return NumericFieldType.numericDocValuesRangeQuery(sf.getName(), minBits, maxBits, true, true, true);
    }

    public static Query numericDocValuesRangeQuery(String field, Number lowerValue, Number upperValue, boolean lowerInclusive, boolean upperInclusive, boolean multiValued) {
        long actualLowerValue = Long.MIN_VALUE;
        if (lowerValue != null) {
            actualLowerValue = lowerValue.longValue();
            if (!lowerInclusive) {
                if (actualLowerValue == Long.MAX_VALUE) {
                    return new MatchNoDocsQuery();
                }
                ++actualLowerValue;
            }
        }
        long actualUpperValue = Long.MAX_VALUE;
        if (upperValue != null) {
            actualUpperValue = upperValue.longValue();
            if (!upperInclusive) {
                if (actualUpperValue == Long.MIN_VALUE) {
                    return new MatchNoDocsQuery();
                }
                --actualUpperValue;
            }
        }
        if (multiValued) {
            return SortedNumericDocValuesField.newSlowRangeQuery((String)field, (long)actualLowerValue, (long)actualUpperValue);
        }
        return NumericDocValuesField.newSlowRangeQuery((String)field, (long)actualLowerValue, (long)actualUpperValue);
    }

    static long parseLongFromUser(String fieldName, String val) {
        if (val == null) {
            throw new NullPointerException("Invalid input" + (null == fieldName ? "" : " for field " + fieldName));
        }
        try {
            return Long.parseLong(val);
        }
        catch (NumberFormatException e) {
            String msg = "Invalid Number: " + val + (null == fieldName ? "" : " for field " + fieldName);
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, msg);
        }
    }

    static int parseIntFromUser(String fieldName, String val) {
        if (val == null) {
            throw new NullPointerException("Invalid input" + (null == fieldName ? "" : " for field " + fieldName));
        }
        try {
            return Integer.parseInt(val);
        }
        catch (NumberFormatException e) {
            String msg = "Invalid Number: " + val + (null == fieldName ? "" : " for field " + fieldName);
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, msg);
        }
    }

    static double parseDoubleFromUser(String fieldName, String val) {
        if (val == null) {
            throw new NullPointerException("Invalid input" + (null == fieldName ? "" : " for field " + fieldName));
        }
        try {
            return Double.parseDouble(val);
        }
        catch (NumberFormatException e) {
            String msg = "Invalid Number: " + val + (null == fieldName ? "" : " for field " + fieldName);
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, msg);
        }
    }

    static float parseFloatFromUser(String fieldName, String val) {
        if (val == null) {
            throw new NullPointerException("Invalid input" + (null == fieldName ? "" : " for field " + fieldName));
        }
        try {
            return Float.parseFloat(val);
        }
        catch (NumberFormatException e) {
            String msg = "Invalid Number: " + val + (null == fieldName ? "" : " for field " + fieldName);
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, msg);
        }
    }
}

